VERSION 5.00
Object = "{EAB22AC0-30C1-11CF-A7EB-0000C05BAE0B}#1.1#0"; "shdocvw.dll"
Object = "{19B7F2A2-1610-11D3-BF30-1AF820524153}#1.1#0"; "ccrpftv6.ocx"
Begin VB.UserControl ExplorerView 
   Appearance      =   0  'Flat
   ClientHeight    =   3015
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4980
   ScaleHeight     =   3015
   ScaleWidth      =   4980
   ToolboxBitmap   =   "ExplorerView.ctx":0000
   Begin CCRPFolderTV6.FolderTreeview FTV1 
      Height          =   1500
      Left            =   240
      TabIndex        =   3
      Top             =   1140
      Width           =   1845
      _ExtentX        =   3254
      _ExtentY        =   2646
      IntegralHeight  =   0   'False
   End
   Begin SHDocVwCtl.WebBrowser WebBrowser1 
      Height          =   1515
      Left            =   3000
      TabIndex        =   2
      Top             =   1170
      Width           =   1695
      ExtentX         =   2990
      ExtentY         =   2672
      ViewMode        =   1
      Offline         =   0
      Silent          =   0
      RegisterAsBrowser=   0
      RegisterAsDropTarget=   1
      AutoArrange     =   -1  'True
      NoClientEdge    =   0   'False
      AlignLeft       =   0   'False
      ViewID          =   "{0057D0E0-3573-11CF-AE69-08002B2E1262}"
      Location        =   ""
   End
   Begin VB.Timer tmrNavigating 
      Left            =   3990
      Top             =   270
   End
   Begin VB.Frame Frame1 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      Caption         =   "Frame1"
      ClipControls    =   0   'False
      ForeColor       =   &H80000008&
      Height          =   1455
      Left            =   2340
      TabIndex        =   1
      Top             =   1170
      Width           =   315
   End
   Begin VB.Label Label1 
      Caption         =   "FolderTreeview designtime property settings : Name = ""FTV1"", IntegralHeight = False"
      Height          =   555
      Left            =   210
      TabIndex        =   0
      Top             =   240
      Visible         =   0   'False
      Width           =   3435
   End
End
Attribute VB_Name = "ExplorerView"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

' Brought to you by Brad Martinez
'   http://www.mvps.org/ccrp/
'   news://news.mvps.org/ccrp.foldertreeview

' =========================================================
' Demonstrates the how to use the WebBrowser control with the
' FolderTreeview control.
'
' Note that it has been observed that both VB5 and VB6 will produce an
' error when the IDE is closed after this demo run on a WinNT5 b2 installation.
' This also occurs when the demo's compiled executable is closed. The cause
' of this error appears to be a result of both navigating the WebBrowser to the
' desktop folder's PIDL, and changing the WebBrowser's default Large Icons
' folder view to Details view. At the time of this demo's release, the exact source
' of this error had not been determined, but appears exclusive to WinNT5 b2.
' The error was not encountered in other IE5 installations, nor in Win2000 b3.
'
' Also note that this demo (and <gulp>, perhaps the FTV) quickly becomes
' obsolete in IE5 due to the new option of be able to use the "All Folders"
' Explorer bar in Internet Explorer instances. But at least it was fun to write...
'
' - Code was developed using (and is formatted for) 8pt. MS Sans Serif font
' =========================================================

' Private definitions

' window handles...
Private m_hwndWB As Long         ' WebBrowser
Private m_hwndSHView As Long  ' any child SHELLDLL_DefView (or other) in the WebBrowser
Private m_hwndLV As Long          ' WebBrowser's grandchild listview (when not in web view)
Private m_hwndSB As Long          ' statusbar
Private m_hwndPB As Long          ' progressbar

' progressbar height, and part width
Private m_cyPB As Long
Private m_cxPart2 As Long

' The displayname of the folder that was right-clicked in the
' WebBrowser's listview control. Is set in the DoLVMessage
' proc, and is selected in the FTV in SHViewWndProc.
Private m_sRClickedLVFolder As String

' Is used to set the statusbar's simple mode for menu help text.
Private m_fInMenuMode As Boolean

' Flag used to apply the FTV's SelectionDelay property for
' FTV keyboard navigation only.
Private m_fFTVKeyNavigate As Boolean

Private VSplitter As New CVSplitterWnd

' =========================================================
' Member definitions

Public Enum evViewConstants
  evLargeIcons = LVS_ICON
  evSmallIcons = LVS_SMALLICON
  evList = LVS_LIST
  evDetails = LVS_REPORT
  evThumbnails = &H8000&   ' IE5 only, read-only
End Enum

Private m_sSelectedFolder As String
Private m_fContextMenu As Boolean
Private m_bSplitPercent As Byte
Private m_dwView As evViewConstants

Private m_fCanNavBack As Boolean
Private m_fCanNavForward As Boolean

Event NavigateComplete(ByVal DisplayName As String, ByVal Path As String)
'

' ===================================================================
' UserControl

Private Sub UserControl_InitProperties()
  
  ' Store the selected folder in the mod level variable instead
  ' of setting the FTV's SelectedFolder here. We will then set
  ' the SelectedFolder in the InitializeControl proc after we get
  ' the WebBrowser's window handle and subclass it...
  
  m_sSelectedFolder = FTV1.GetSpecialFolderName(ftvDesktop)
  m_fContextMenu = True
  m_bSplitPercent = 35
  m_dwView = evLargeIcons
  
  Call InitializeControl

End Sub

Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
  
  m_sSelectedFolder = PropBag.ReadProperty("SelectedFolder", FTV1.GetSpecialFolderName(ftvDesktop))
  m_fContextMenu = PropBag.ReadProperty("ContextMenu", True)
  m_bSplitPercent = PropBag.ReadProperty("SplitPercent", 35)
  m_dwView = PropBag.ReadProperty("View", evLargeIcons)
  
  Call InitializeControl

End Sub

Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
    
  Call PropBag.WriteProperty("SelectedFolder", CStr(FTV1.SelectedFolder), FTV1.GetSpecialFolderName(ftvDesktop))
  Call PropBag.WriteProperty("ContextMenu", m_fContextMenu, True)
  Call PropBag.WriteProperty("SplitPercent", m_bSplitPercent, 35)
  Call PropBag.WriteProperty("View", m_dwView, evLargeIcons)

End Sub

Private Sub InitializeControl()
    
  ' ======================================================
  ' WebBrowser
  
  ' Get the WebBrowser's hWnd (HWND in an Internet
  ' Explorer object property), and subclass it.
  m_hwndWB = FindWindowEx(UserControl.hWnd, 0, WC_WEBBROWSER, vbNullString)
  If m_hwndWB Then Call SubClass(m_hwndWB, AddressOf WBWndProc, Me)

'  If m_hwndWB Then
'    Call SetWindowLong(m_hwndWB, GWL_STYLE, _
'                                      (GetWindowLong(m_hwndWB, GWL_STYLE) And Not WS_BORDER))
'  End If
  
  ' ======================================================
  ' VSplitter
  
  ScaleMode = vbPixels

' Read-only at runtime properties, must be set at designtime...
'  Frame1.Appearance = 0   ' flat
'  Frame1.BorderStyle = vbBSNone   ' hides the caption
'  Frame1.ClipControls = False
  
  With VSplitter
    Call .SetControls(UserControl.hWnd, GetParent(FTV1.hWnd), m_hwndWB, Frame1)
    .Percent = m_bSplitPercent
    .TrackSplit = True
  End With

  ' ======================================================
  ' FolderTreeview
  
  With FTV1
' Read-only at runtime properties, must be set at designtime...
'    .Name = "FTV1"
'    .IntegralHeight = False
    ' This is the solution for a bug in the FTV, were the FTV acts as if
    ' were running when in designtime and sited in another UserControl.
    ' See the Revision Info.txt file in the FTV zip's "docs" folder.
    .Enabled = (DesignTime = False)
    .HideSelection = True
    ' The SelectionDelay property returns/sets the time in milliseconds that
    ' the *second* SelectionChange event (PreChange = False) is delayed.
    .SelectionDelay = 500
    .TabIndex = 0
  End With
  
  ' ======================================================
  ' Navigational timer that hides the progressbar and restores the mouse
  ' pointer. If a navigational error occurs, in which case the WebBrowser's
  ' NavigateComplete2 event *may not occur*, the progressbar and the
  ' hourglass will not be restored.
  
  ' Set the timer so that it has a longer interval than the FTV's SelectionDelay
  ' property, since the Timer's enabled property is used as a flag that indicates
  ' when currently navigating.
  
  tmrNavigating.Interval = 700
  tmrNavigating = False
  
  ' ======================================================
  ' statusbar
  
  Dim rc As RECT
  
  ' is destroyed when the form is destoyed (we don't have to do it)
  m_hwndSB = CreateStatusWindow(WS_CHILD Or WS_VISIBLE Or CCS_BOTTOM Or _
                                                          ((DesignTime = False) And SBARS_SIZEGRIP), _
                                                          vbNullString, hWnd, 0)
  If m_hwndSB Then
            
    ' Get the statusbar's default height and establish the fixed
    ' width of its 2nd part for resizing in UserControl_Resize.
    Call GetWindowRect(m_hwndSB, rc)
    m_cyPB = rc.Bottom - rc.Top
    m_cxPart2 = 150
    
    ' offset the splitter's height to accommodate the statusbar's height
    VSplitter.HeightOffset = m_cyPB
  
  End If   ' m_hwndSB

  ' ======================================================
  ' progressbar, used only when loading a web page.
  
  If m_hwndSB Then
    ' is destroyed when the form is destoyed (we don't have to do it)
    m_hwndPB = CreateWindowEx(0, PROGRESS_CLASSA, vbNullString, _
                                                      WS_CHILD Or PBS_SMOOTH, _
                                                      0, 0, 0, 0, _
                                                      m_hwndSB, 0, _
                                                      App.hInstance, ByVal 0)   ' WS_VISIBLE
    
    ' Remove the progressbar's default 3D border
    If m_hwndPB Then
      Call SetWindowLong(m_hwndPB, GWL_EXSTYLE, _
                                        (GetWindowLong(m_hwndPB, GWL_EXSTYLE) And Not WS_EX_STATICEDGE))
    End If
  End If   ' m_hwndSB
  
  ' ======================================================
  ' Finally...
  
  ' Set the FTV's SelectedFolder here from the mod level Folder
  ' that was set in UserControl_Init/ReadProperties, invoking the
  ' FTV's SelectionChange event, which loads everything up...
  ' (SelectionChange normally occurs when the FTV first appears)
  FTV1.SelectedFolder = m_sSelectedFolder
  
  If DesignTime Then
    Call UnSubClassWBWindows
    ' The Resize event doesn't fire in designtime after the props are read
    Call UserControl_Resize
  End If
  
  ' Let everything happen before the UserControl is shown...
  DoEvents
  
End Sub

Private Sub UnSubClassWBWindows()
  If m_hwndWB Then Call UnSubClass(m_hwndWB)
  If m_hwndSHView Then Call UnSubClass(m_hwndSHView)
  If m_hwndLV Then Call UnSubClass(m_hwndLV)
End Sub

Private Sub UserControl_Show()
  Call RaiseNavigateComplete(FTV1.SelectedFolder.DisplayName, FTV1.SelectedFolder.FullPath)
End Sub

Friend Function DesignTime() As Boolean
  On Error GoTo Out
  DesignTime = (Ambient.UserMode = False)
Out:
End Function

Private Sub UserControl_Resize()
  Static cxScale As Long
  Static rc As RECT
  Static axParts(1) As Long
  
  Call VSplitter.AdjustSplitterPosition(True)
  
  cxScale = ScaleWidth
  
  If m_hwndSB Then
    
    ' tell the statusbar to update it's potition at the bottom of the form
    Call SendMessage(m_hwndSB, WM_SIZE, 0, 0)
    
    ' set the statusbar part widths...
    axParts(0) = cxScale - m_cxPart2
    axParts(1) = -1
    Call SendMessage(m_hwndSB, SB_SETPARTS, 2, axParts(0))

    ' Move the progressbar over the statusbar's 2rd part, reducing it's
    ' entire rect by one pixel so we see the part's WS_EX_STATICEDGE.
    ' The progressbar is invisible unless currently navigating in web view.
    If m_hwndPB Then
      Call StatusBar_GetPartRect(m_hwndSB, 1, rc)
      Call MoveWindow(m_hwndPB, rc.Left + 1, rc.Top + 1, (rc.Right - rc.Left) - 2, (rc.Bottom - rc.Top) - 2, CTrue)
    End If   ' m_hwndPB
    
    ' The status bar needs a little help repainting itself, sometimes... (?)
    Call InvalidateRect(m_hwndSB, ByVal 0, CTrue)
  
  End If   ' m_hwndSB

End Sub

Private Sub UserControl_Terminate()
  Call UnSubClassWBWindows
  Set VSplitter = Nothing
End Sub

' ===================================================================
' Friend Members:

Friend Property Get hwndUC() As Long
  hwndUC = UserControl.hWnd
End Property

Friend Property Get hwndFTV() As Long
  hwndFTV = GetParent(FTV1.hWnd)
End Property

Friend Property Get hwndWB() As Long
  hwndWB = m_hwndWB
End Property

Friend Property Get hwndSHView() As Long
  hwndSHView = m_hwndSHView
End Property

Friend Property Let hwndSHView(hWnd As Long)
  m_hwndSHView = hWnd
End Property

Friend Property Get hwndLV() As Long
  hwndLV = m_hwndLV
End Property

Friend Property Let hwndLV(hWnd As Long)
  m_hwndLV = hWnd
End Property

Friend Property Get UserView() As Long
  UserView = m_dwView
End Property

' The displayname of the folder that was right-clicked in the
' WebBrowser's listview control. Is set in the DoLVMessage
' proc, and is selected in the FTV in SHViewWndProc.

Friend Property Get RClickedLVFolder() As String
  RClickedLVFolder = m_sRClickedLVFolder
End Property

Friend Property Let RClickedLVFolder(sFolder As String)
  m_sRClickedLVFolder = sFolder
End Property

Friend Property Let InMenuMode(fMenuMode As Boolean)
  
  If fMenuMode Then
    ' set the statusbar to simple mode
    Call StatusBar_SetSimple(m_hwndSB, True)
    Call StatusBar_SetPartText(m_hwndSB, SB_SIMPLEPARTINDEX, SBT_NOBORDERS, "")
  Else
    ' when exiting menu mode, no StatusTextChange will occur to
    ' clear the menu help text in the statusbar, so we'll call the
    ' function explicitly (have to clear the proc's part flag).
    Call WebBrowser1_StatusTextChange("")
    Call StatusBar_SetSimple(m_hwndSB, False)
  End If
  
  m_fInMenuMode = fMenuMode

End Property

' ===================================================================
' Public properties

Public Property Get FolderTreeview() As Object
  Set FolderTreeview = FTV1
End Property

Public Property Get WebBrowser() As Object
  Set WebBrowser = WebBrowser1
End Property

Public Property Get ContextMenu() As Boolean
  ContextMenu = m_fContextMenu
End Property

Public Property Let ContextMenu(fContextMenu As Boolean)
  m_fContextMenu = fContextMenu
  Call PropertyChanged("ContextMenu")
End Property

Public Property Get Enabled() As Boolean
  Enabled = UserControl.Enabled
End Property

Public Property Let Enabled(fEnable As Boolean)
  UserControl.Enabled = fEnable
  Call PropertyChanged("Enabled")
End Property

Public Property Get SelectedFolder() As String
  SelectedFolder = FTV1.SelectedFolder
End Property

Public Property Let SelectedFolder(sFolder As String)
  If (FTV1.SelectedFolder <> sFolder) Then
    If DesignTime Then Call SubClass(m_hwndWB, AddressOf WBWndProc, Me)
    FTV1.SelectedFolder = sFolder
    If DesignTime Then
      Call UnSubClassWBWindows
      Call FTV1.SelectedFolder.CollapseAllButMe
    End If
    Call PropertyChanged("SelectedFolder")
  End If
End Property

Public Property Get ShellVersion() As Single
  ShellVersion = FTV1.ShellVer
End Property

Public Property Get SplitPercent() As Byte
  SplitPercent = m_bSplitPercent
End Property

Public Property Let SplitPercent(bSplitPercent As Byte)
  VSplitter.Percent = bSplitPercent
  ' Read the value the property was set to.
  m_bSplitPercent = VSplitter.Percent
  Call PropertyChanged("SplitPercent")
End Property

' Return the view dynamically, as it may have been
' changed from the listview's context menu.

Public Property Get View() As evViewConstants

  If IsWindow(m_hwndLV) Then
    If InThumbnailView(m_hwndWB) Then
      View = evThumbnails
    Else
      View = (GetWindowLong(m_hwndLV, GWL_STYLE) And LVS_TYPEMASK)
    End If
  
  Else
    View = m_dwView
  End If

End Property

Public Property Let View(dwView As evViewConstants)
  
  ' test for valid values, we're not setting thumbnail view...
  If (dwView >= 0) And (dwView <= LVS_TYPEMASK) Then
    If ((GetWindowLong(m_hwndLV, GWL_STYLE) And LVS_TYPEMASK) <> dwView) Then
      If DesignTime Then Call SubClass(m_hwndWB, AddressOf WBWndProc, Me)
      Call SwitchView(m_hwndLV, dwView)
      If DesignTime Then Call UnSubClassWBWindows
      m_dwView = dwView
      Call PropertyChanged("View")
    End If
  End If
  
End Property

Public Property Get LargeIcon() As StdPicture
  Set LargeIcon = FTV1.SelectedFolder.LargeIcon
End Property

Public Property Get SmallIcon() As StdPicture
  Set SmallIcon = FTV1.SelectedFolder.SmallIcon
End Property

' ===================================================================
' Public methods

Public Sub CancelSplit()
  ' When the UserControl's KeyPreview = True, we only get keyboard
  ' events when the FTV has the focus, but not when the WebBrowser,
  ' or one of its child windows has the focus. Since it's too much of a
  ' hassle to trap an Escape keypress in the WebBrowser's windows,
  ' we'll just expose this method, passing off split cancelling onto the client.
  If VSplitter.Splitting Then Call VSplitter.CancelSplit
End Sub

Public Function CanNavigateBack() As Boolean
  CanNavigateBack = m_fCanNavBack
End Function

Public Function CanNavigateForward() As Boolean
  CanNavigateForward = m_fCanNavForward
End Function

Public Sub Refresh()
  Dim sURL As String
  
  FTV1.Refresh
  
  If InWebView Then
    ' Refresh/2 are Internet Explorer object methods (not WebBrowser)
    ' so we have to explicitly refresh when viewing a web page.
    sURL = WebBrowser1.LocationURL
    Call NavigateToURL("about:blank")
    DoEvents
    Call NavigateToURL(sURL)
  Else
    If Len(FTV1.SelectedFolder.FullPath) Then
      Call NavigateToURL(FTV1.SelectedFolder.FullPath)
    Else
      Call NavigateToPIDL(FTV1.SelectedFolder.pidlFQ)
    End If
  End If

End Sub

' Navigate to the folder/URL. If a virtual folder name recognized
' by the FTV, have the FTV navigate the WebBrowser to it,
' otherwise have the WebBrowser navigate the FTV to it...

Public Sub NavigateTo(sURL As String)
  If IsVirtualFolderName(sURL) Then
    FTV1.SelectedFolder = sURL
  Else
    Call NavigateToURL(sURL)
  End If
End Sub

Public Sub NavigateBack()
  On Error GoTo Out
  WebBrowser1.GoBack
Out:
End Sub

Public Sub NavigateForward()
  On Error GoTo Out
  WebBrowser1.GoForward
Out:
End Sub

Public Sub NavigateStop()
  ' call does not set WB1.ReadyState = READYSTATE_COMPLETE
  ' so we have to explicity turn off the timer and reset the mousepointer
  Call WebBrowser1.Stop
  Call RemoveNavigationUI
End Sub

Public Function InWebView() As Boolean
  InWebView = CBool(FindWindowEx(m_hwndWB, 0, WC_WEBVIEW, vbNullString))
End Function

' ===================================================================
' private members

' When no longer navigating, turn the timer off, make sure that the
' progressbar is hidden, and that the mousepointer is restored.
' If a navigational error occured, the WebBrowser's NavigateComplete2
' event *may not occur*, making it unreliable to do this stuff there...

Private Sub RemoveNavigationUI()
  tmrNavigating = False
  Call ShowWindow(m_hwndPB, SW_HIDE)
  MousePointer = vbDefault
End Sub

' Determines if the WebBrowser is in thumbnail view.
' Pass the WebBrowser window handle on first call.

Private Function InThumbnailView(hwndParent As Long) As Boolean
  Dim hwndChild As Long
  Dim fThumbnails As Boolean
  
  hwndChild = FindWindowEx(hwndParent, 0, vbNullString, vbNullString)
  
  Do While hwndChild
    
    ' first check the children of the current child
    fThumbnails = CBool(FindWindowEx(hwndChild, 0, WC_THUMBVIEW, vbNullString))
      
    ' next check the grand children of the current child
    If (fThumbnails = False) Then
      fThumbnails = InThumbnailView(hwndChild)
    End If
    
    ' if we found the WC_THUMBVIEW window, return True and exit.
    If fThumbnails Then
      InThumbnailView = True
      Exit Function
    End If
    
    ' get the current child window's next sibling window
    hwndChild = FindWindowEx(hwndParent, hwndChild, vbNullString, vbNullString)
    
  Loop
    
End Function

' Navigate the WebBrowser to the specified URL.

Private Sub NavigateToURL(sURL As String)
  Dim fIsCurrentURL As Boolean
    
  ' The WebBrowser's LocationURL errs sometimes...
  On Error Resume Next
  fIsCurrentURL = (sURL = WebBrowser1.LocationURL)
  On Error GoTo 0
  
  If (fIsCurrentURL = False) Then
    WebBrowser1.Navigate sURL
    DoEvents
  End If
  
End Sub

' Navigate the WebBrowser to the folder specified by the pidl.

Private Function NavigateToPIDL(pidl As Long) As Boolean
  Dim cbpidl As Integer
  Dim abpidl() As Byte
  Dim avpidl As Variant
  
  If pidl Then
    
    ' Get the folder's item ID list size
    cbpidl = GetPIDLSize(pidl)
    If cbpidl Then
      
      ' Reallocate the byte array and copy the folder's item ID list to the array.
      ReDim abpidl(cbpidl - 1)   ' zero based
      MoveMemory abpidl(0), ByVal pidl, cbpidl
      
      ' Load the pidl's byte aray into the variant, tada, a SAFEARRAY...
      ' and navigate the folder's pidl.
      avpidl = abpidl
      WebBrowser1.Navigate2 avpidl
            
      NavigateToPIDL = True
      
    End If   ' cbpidl
  End If   ' pidl

End Function

Private Function IsVirtualFolderName(sPath As String) As Boolean
  Dim fRtn As Boolean
  
  With FTV1
    Select Case True
      Case StrComp(sPath, .GetSpecialFolderName(ftvDesktop), 1) = 0: fRtn = True
      Case StrComp(sPath, .GetSpecialFolderName(ftvMyComputer), 1) = 0: fRtn = True
      Case StrComp(sPath, .GetSpecialFolderName(ftvNetwork), 1) = 0: fRtn = True
      Case StrComp(sPath, .GetSpecialFolderName(ftvInternet), 1) = 0: fRtn = True
      Case StrComp(sPath, .GetSpecialFolderName(ftvRecycled), 1) = 0: fRtn = True
      Case StrComp(sPath, .GetSpecialFolderName(ftvControlPanel), 1) = 0: fRtn = True
      Case StrComp(sPath, .GetSpecialFolderName(ftvPrinters), 1) = 0: fRtn = True
    End Select
  End With
  
  IsVirtualFolderName = fRtn
  
End Function

Private Sub RaiseNavigateComplete(sDisplayName As String, sPath As String)
  ' If navigated to a file ststem folder... (on Win2K, the
  ' CLSIDs of virtual folders are now returned as a path)
  If Len(sPath) And (InStr(sPath, "::{") = 0) Then
    RaiseEvent NavigateComplete(sDisplayName, sPath)
  Else
    RaiseEvent NavigateComplete(sDisplayName, sDisplayName)
  End If
End Sub

' ===================================================================
' Navigation:

' Set the module level flag so that SelectionDelay is used in
' FolderTreeview1_SelectionChange for keyboard navigation.

Private Sub FTV1_KeyDown(KeyCode As Integer, Shift As Integer)
  m_fFTVKeyNavigate = True
End Sub

' Clear the module level flag so that SelectionDelay is not used
' in FolderTreeview1_SelectionChange for mouse navigation.

Private Sub FTV1_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
  m_fFTVKeyNavigate = False
End Sub

' Navigate the WebBrowser to the currently selected FolderTreeview folder.

Private Sub FTV1_SelectionChange(Folder As CCRPFolderTV6.Folder, PreChange As Boolean, Cancel As Boolean)
  Static dwSelectionDelay As Long
  
'Debug.Print "FTV1_SelectionChange", Folder
  
  ' First thing, if a selection change is about to happen and
  ' we're currently navigating (most likely to a URL), make
  ' sure that the WebBrowser stops whatever it may be doing...
  If PreChange And tmrNavigating Then Call NavigateStop
  
  ' If the selection change didn't occur from the keyboard...
  If (m_fFTVKeyNavigate = False) Then
    If PreChange Then
      ' First save, then turn SelectionDelay off before the PreChange = False
      ' event occurs next.
      dwSelectionDelay = FTV1.SelectionDelay
      FTV1.SelectionDelay = 0
    Else
    ' Restore the currently specified value. If the selection change occured
    ' from the keyboard, then this event has been delayed by the specified
    ' SelectionDelay value.
      FTV1.SelectionDelay = dwSelectionDelay
    End If
  End If   ' m_fFTVKeyNavigate
  
  ' Don't process the change if currently navigating (or weird things happen)
  If (PreChange = False) And (tmrNavigating = False) Then
    If Len(Folder.FullPath) Then
      Call NavigateToURL(Folder.FullPath)
    Else
      Call NavigateToPIDL(Folder.pidlFQ)
    End If
  End If   ' (PreChange = False) And (tmrNavigating = False)

End Sub

Private Sub WebBrowser1_BeforeNavigate2(ByVal pDisp As Object, URL As Variant, Flags As Variant, TargetFrameName As Variant, PostData As Variant, Headers As Variant, Cancel As Boolean)

'Debug.Print "WebBrowser1_BeforeNavigate2", URL
'g_fMsgs = True
  
  ' Set the hourglass and start the timer
  MousePointer = vbArrowHourglass
  tmrNavigating = True
  
  ' Clear the statusbar
  Call StatusBar_SetPartText(m_hwndSB, 0, SBT_SUNKEN, "")
  Call StatusBar_SetPartText(m_hwndSB, 1, SBT_SUNKEN, "")
  
  ' Show the progressbar if in webview
  If InWebView Then Call ShowWindow(m_hwndPB, SW_SHOW)

End Sub

Private Sub tmrNavigating_Timer()   ' Interval = 500
  
'Debug.Print WebBrowser1.ReadyState

  If (WebBrowser1.ReadyState = READYSTATE_COMPLETE) Then
    Call RemoveNavigationUI
  End If

End Sub

' Sets the statusbar text. (real statusbar part indices are zero-based)

' Status text *seems* to be sent in pairs (for 2 status panels), *only* when
' viewing file system folders. Otherwise, we'll just set the first status panel.

Private Sub WebBrowser1_StatusTextChange(ByVal Text As String)
  Static fPart2 As Boolean
  
  If m_hwndSB Then
  
    ' If not viewing a web page, and viewing a file system folder (the last test
    ' is for Win2K, the CLSIDs of virtual folders are now returned as a path)
    If (InWebView = False) And Len(FTV1.SelectedFolder.FullPath) And _
        (InStr(FTV1.SelectedFolder.FullPath, "::{") = 0) Then
      ' Set the text in the panel corresponding to the flag's absolute value, then toggle it.
      Call StatusBar_SetPartText(m_hwndSB, Abs(fPart2), SBT_SUNKEN, Text)
      fPart2 = Not fPart2
    
    Else
      ' Either viewing a web page, a virtual folder (no file system path),
      ' or in menu mode, clear the flag, we're setting only the first panel's text
      fPart2 = False
      If m_fInMenuMode Then
        ' In menu mode, set the first panel's text, giving the statusbar the menu "look".
        Call StatusBar_SetPartText(m_hwndSB, SB_SIMPLEPARTINDEX, SBT_NOBORDERS, Text)
      Else
        ' Either viewing a web page, a virtual folder.
        Call StatusBar_SetPartText(m_hwndSB, 0, SBT_SUNKEN, Text)
      End If
    
    End If
  
  End If   ' m_hwndSB

End Sub

' Navigate the FTV to the appropiate folder. This event occurs after each
' "URL" page is loaded, including individual frame pages.

Private Sub WebBrowser1_NavigateComplete2(ByVal pDisp As Object, URL As Variant)
  
'Debug.Print "WebBrowser1_NavigateComplete2", URL
'g_fMsgs = False

' If viewing a web page...
  If InWebView Then
    
    ' Set the FTV to the Internet Explorer folder. If the FTV's
    ' AutoUpdate prop is set to True (which it should be), and
    ' we're not running on Win2K b3 (it no longer does web
    ' page folders under the Internet Explorer folder), the web
    ' page will be selected in FTV1_FolderUpdate below.
    If (FTV1.SelectedFolder <> WebBrowser1.LocationURL) Then
      FTV1.SelectedFolder = FTV1.GetSpecialFolderName(ftvInternet)
      FTV1.SelectedFolder.Expanded = True
    End If
  
    ' let the client know we're done navigating.
    ' don't pass the URL param as it might be a frame's url
    Call RaiseNavigateComplete(WebBrowser1.LocationName, WebBrowser1.LocationURL)
  
  Else
    ' Viewing a shell folder

    ' We do this only for NT5 and the desktop folder
    ' (new shell behavior for NT5: the desktop folder
    ' has a path, which screws our code up here...)
    If (WebBrowser1.LocationName = FTV1.GetSpecialFolderName(ftvDesktop)) Then
      FTV1.SelectedFolder = WebBrowser1.LocationName
    
    ' The URL param may be empty for folder names not
    ' recognized by the WebBrowser
    ElseIf Len(URL) Then
      
      ' We may be navigating the FTV from a TextBox entry.
      ' The FTV ignores this assignment if the SelectedFolder
      ' is aready set to URL, *unless* the SelectedFolder resides
      ' under the desktop folder (or any other folder that is both
      ' virtual, and physical), in which case the SelectedFolder
      ' will be set to its *physical* location.
      If (FTV1.SelectedFolder <> URL) Then FTV1.SelectedFolder = URL
      
    ' The folder is not recognized by the WebBrowser, assume
    ' that it's already the FTV's SelectedFolder
    Else
      '...
    End If
    
    ' let the client know we're done navigating.
    Call RaiseNavigateComplete(FTV1.SelectedFolder.DisplayName, FTV1.SelectedFolder.FullPath)
  
  End If   ' InWebView
  
  ' Select, then deselect, the listview's first item, invoking any
  ' StatusTextChange for the folder (if it does IShellDetatils)
  If m_hwndLV Then
    Call ListView_SetSelectedItem(m_hwndLV, 0, True)
    Call ListView_SetSelectedItem(m_hwndLV, 0, False)
  End If
  
  ' Clear the module level flag so that the FTV's SelectionDelay
  ' is property not used in FolderTreeview1_SelectionChange
  ' for anything but keyboard navigation.
  m_fFTVKeyNavigate = False
  
  MousePointer = vbDefault
  
End Sub

' Sets the progressbar when a web page is loading.

Private Sub WebBrowser1_ProgressChange(ByVal Progress As Long, ByVal ProgressMax As Long)
  Call SendMessage(m_hwndPB, PBM_SETRANGE32, 0, ByVal ProgressMax)
  Call SendMessage(m_hwndPB, PBM_SETPOS, Progress, ByVal 0&)
End Sub

' Sets the CanNavBack and CanNavForward property variables

Private Sub WebBrowser1_CommandStateChange(ByVal Command As Long, ByVal Enable As Boolean)
  
  ' one if the SHDocVwCtl.CommandStateChangeConstants
  Select Case Command
    Case CSC_NAVIGATEBACK
      m_fCanNavBack = Enable
    Case CSC_NAVIGATEFORWARD
      m_fCanNavForward = Enable
  End Select

End Sub

' ===============================================================
' FolderTreeview

' If viewing a web page, selects the currently browsed URL folder
' under the Interenet Explorer folder (Win2K b3 no longer shows
' URL folders under the Interenet Explorer folder).

Private Sub FTV1_FolderUpdate(FolderName As String, EventID As CCRPFolderTV6.ftvFolderUpdateConstants)
  Dim fldChild As CCRPFolderTV6.Folder
  
  ' If in web view and a folder's contents are being updated ,
  ' and the FTV's SelectedFolder is the Internet Explorer folder....
  If (EventID = ftvFolderContentsUpdated) And InWebView Then
    If (FTV1.SelectedFolder = FTV1.GetSpecialFolderName(ftvInternet)) Then
    
      ' Find and select the new URL folder under Internet Explorer folder.
      Set fldChild = FTV1.SelectedFolder.Child
      Do While (fldChild Is Nothing) = False

'Debug.Print fldChild.FullPath, WebBrowser1.LocationURL
        
        ' If the URL folder's FullPath matches the currently browsed web
        ' page, the we found what we were looking for...
        If (fldChild.FullPath = WebBrowser1.LocationURL) Then
          
          ' Prevent the FTV from re-navigating to this folder (the selection
          ' below invokes FTV1_SelectionChange)
          tmrNavigating = True
          
          ' Select the URL folder, and let the client know we're done navigating.
          fldChild.Selected = True
          Call RaiseNavigateComplete(fldChild.DisplayName, fldChild.FullPath)
          
          Exit Do
        
        End If   ' (fldChild.FullPath = WebBrowser1.LocationURL)
        
        ' Get the current folder's next sibling.
        Set fldChild = fldChild.NextSibling
      Loop
  
    End If
  End If
  
End Sub

' ===============================================================
' Splitter

Private Sub Frame1_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
  If Button = vbLeftButton Then Call VSplitter.BeginSplit(x, y)
End Sub

Private Sub Frame1_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
  If VSplitter.Splitting Then Call VSplitter.MoveSplitter(x, y)
End Sub

Private Sub Frame1_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
  If VSplitter.Splitting Then Call VSplitter.EndSplit(x, y, True)
End Sub

' ===============================================================
'
'Private Sub WebBrowser1_PropertyChange(ByVal szProperty As String)
'  Debug.Print "WB_PropertyChange: " & szProperty, WebBrowser1.GetProperty("szProperty")
'End Sub
